from mrjob.job import MRJob
from mrjob.step import MRStep

class MRFriends(MRJob):

    def mapper(self, _, line):
        f_from, to_str = line.split("->")
        f_from         = f_from.strip()
        friends_to     = to_str.strip().split()
        for f_to in friends_to:
            if f_from > f_to:
                yield (f_to, f_from), friends_to
            else:
                yield (f_from, f_to), friends_to

    def reducer(self, pair, neighbors):
        common_neighbors = set.intersection(
            *[set(i) for i in neighbors])
        yield pair, list(common_neighbors)

if __name__ == "__main__":
    MRFriends().run()
