from mrjob.job import MRJob

import re

WORD_REGEX = re.compile(r"[\w]+")

class MRWordCount(MRJob):
    def mapper(self, _, line):
        for word in WORD_REGEX.findall(line):
            yield word.lower(), 1

    def reducer(self, word, count):
        yield word, sum(count)

if __name__ == "__main__":
    MRWordCount().run()
