import random
import threading

num_odd = 0

generator_lock = threading.Lock()
counter_lock = threading.Lock()

def worker(stream):
    # stream: an object that implements the __next__ method
    #         raises StopIteration when all its elements are consumed
    global num_odd
    # NOTE: If you acquire a lock *before* the start of the loop, your code is effectively single-threaded
    while True:
        try:
            with generator_lock:
                elt = next(stream)      # 1st race condition
            if elt % 2 == 1:
                with counter_lock:
                    num_odd += 1        # 2nd race condition
        except StopIteration:
            return


# Another possible solution (worker2) *without* using a context manager
def worker2(stream):
    global num_odd
    while True:
        try:
            generator_lock.acquire()
            elt = next(stream)              # NOTE: This could raise a StopIteration
            generator_lock.release()        # so we need to release() the lock in the `except` block as well
            if elt % 2 == 1:
                counter_lock.acquire()
                num_odd += 1
                counter_lock.release()
        except StopIteration:
            generator_lock.release()
            return

if __name__ == "__main__":
    # create stream
    stream = (random.randint(0, 100) for _ in range(10000))
    # 16 threads
    threads = [threading.Thread(target=worker, args=(stream,)) for _ in range(16)]
    # run and wait
    for t in threads: t.start()
    for t in threads: t.join()
    print("The number of odd elements was: {}".format(num_odd))
