import numpy as np
from math import ceil
from os import cpu_count
from multiprocessing import Pool

def trial(m):
    samples = np.random.uniform(-1.0, 1.0, size=(m, 2))
    # Note: {sqrt(x^2 + y^2) <= 1} <=> {x^2 + y^2 <= 1}
    success = sum(np.sum(samples ** 2, axis=1) <= 1)
    return success

if __name__ == "__main__":
    nproc = cpu_count()
    N     = 50000 * nproc          # try 50000 samples per machine
    m_per = [N // nproc] * nproc
    with Pool(processes=nproc) as pool:
        print("Estimate of pi: ", 4 * sum(pool.map(trial, m_per)) / N)
