import numpy as np

def randomStream(m, n):
    # (<expr(i)> for i in iterable) returns a generator
    # the generator expression is evaluated as needed
    return (np.random.randint(0, m) for _ in range(n))

def reservoir_sampler(stream, k):
    # collect first k elements into reservoir
    reservoir = [next(stream) for _ in range(k)]
    idx = k
    for elt in stream:
        idx += 1
        if np.random.rand() <= (k / idx):
            # replace a randomly chosen element
            reservoir[np.random.randint(k)] = elt
    return reservoir

def count_min_sketch(stream, m, t, k, f):
    C = np.zeros((t, k))
    h = [genHash(m, k) for _ in range(t)]
    for elt in stream:
        # update all locations implied by hash funcs
        for i in range(t):
            C[i, h[i](elt)] += 1
    # 2 ways to find the f elements with largest frequencies
    # Method I: Use min-heap with f locations (space-efficient)
    # Method II: Find all `m` frequencies, put them in list, sort list
    #            (space-inefficient, but will get all the points)
    freq_list = [min(C[i, h[i](elt)] for i in range(t)) for elt in range(m)]
    return np.argsort(freq_list)[-f:]
