from math import ceil, sqrt
import numpy as np

def is_prime(x):
    """
    Check if `x` is prime.
    """
    return all(x % i != 0 for i in range(2, int(sqrt(x)) + 2))


def next_prime(x):
    """
    Find the next prime number that is strictly bigger than `x`.
    """
    for i in range(x+1, 2 * x):
        if is_prime(i):
            return i

def genHash(m, k):
    p = next_prime(m)
    a = np.random.randint(1, p)
    b = np.random.randint(0, p)
    return lambda x: ((a * x + b) % p) % k


class BloomFilter(object):

    def __init__(self, m, n, k, p=None):
        if not p:
            num_hash = ceil(np.log(2) * (k / n))
        else:
            num_hash = p
        # create the hash functions
        self.hash_funs = [genHash(m, k) for _ in range(num_hash)]
        # create the bit array
        self.A = np.zeros(k)
        # NOTE: You can also use a built-in bitarray object here

    def empty(self):
        self.A[:] = 0.0     # fill with zeros

    def insert(self, x):
        if self.lookup(x):
            return False
        for fun in self.hash_funs:
            A[fun(x)] = 1.0
        return True

    def lookup(self, x):
        return all(A[fun(x)] for fun in self.hash_funs)


