import numpy as np

def all_pairs_dist(X):
    # matrix of inner products
    ips = X @ X.T
    return np.diag(ips)[:, None] + np.diag(ips)[:, None].T - 2 * ips

# NOTE:
# np.diag() returns a numpy vector, which is not affected by .T (cannot be transposed)
# to get around that, we explicitly cast the result to a (n, 1) array by adding
# a dimension - this is where [:, None] is useful
