import numpy as np

def project_sparse(v, k):
    n = v.length
    u = v[:]   # copy
    u[np.argsort(np.abs(v))[:(n - k)]] = 0.0
    return u

def iht_solve(A, y, x_0, T, eta, k):
    x = x_0[:] # copy
    for i in range(T):
        x = project_sparse(x - eta * A.T @ (A @ x - y), k)
    return x


