#!/usr/bin/env python

# Problem 1: The correct ordering is: [9, 11, 6, 4, 3, 2, 1, 10, 5, 7, 8]

# -------------------------
# Problem 2: Power function

import random
import numpy as np
import numpy.linalg as linalg

def pow(x, n):
    if n < 0:
        return pow(1 / x, -n)
    if n == 0:
        return 1
    if n % 2 == 1:
        return x * pow(x * x, n // 2)
    else:
        return pow(x * x, n // 2)


def matrix_pow(A, n):
    vals, Q = linalg.eigh(A)
    return (Q * pow(vals, n)) @ Q.T
    # alternatively:
    # Q @ np.diag(pow(vals, n)) @ Q.T


# -------------------------------
# Problem 3: merging sorted lists

# auxiliary function for merging only two sorted lists
# Running time: O(n + m)
def merge_aux(list_a, list_b):
    n, m = len(list_a), len(list_b)
    C = [0] * (n + m)
    i = j = 0
    while i < n and j < m:
        if list_a[i] < list_b[j]:
            C[i + j] = list_a[i]
            i += 1
        else:
            C[i + j] = list_b[j]
            j += 1
    # at the end of the `while` loop, one of the lists is empty
    C[(i + j):] = list_a[i:] + list_b[j:]
    return C

def simple_merge(list_of_lists):
    list_init = []
    for ls in list_of_lists:
        list_init = merge_aux(list_init, ls)
    return list_init

# The below is a divide-and-conquer approach
def merge(list_of_lists):
    K = len(list_of_lists)
    # base case: only 1 list - return the list itself
    if K == 1:
        return list_of_lists[0]
    bot_half = merge(list_of_lists[:(K // 2)])
    top_half = merge(list_of_lists[(K // 2):])
    return merge_aux(bot_half, top_half)

# ------------------------------
# Problem 4: Iterative quicksort

def partition(A, p, r):
    # choose a pivot at random
    rand_idx = random.randint(p, r)
    # swap elements to bring A[rand_idx] to the end
    A[rand_idx], A[r] = A[r], A[rand_idx]
    # continue with standard code
    pivot = A[r]
    i = p - 1
    for j in range(p, r):
        if A[j] < pivot:
            i += 1
            A[i], A[j] = A[j], A[i]
    i += 1
    A[i], A[r] = A[r], A[i]
    return i


import copy
from collections import deque

def quicksort_iter(A):
    # OPTIONAL: make a copy of the array so that we don't overwrite it
    Acopy = copy.deepcopy(A)
    stack = deque([])
    # use a stack to keep track of which part of the array must be partitioned next
    stack.append((0, len(A) - 1))
    # terminate when stack is empty
    while stack:
        p, r = stack.pop()
        # if p >= r, nothing left to partition
        if p >= r:
            break
        pivot_idx = partition(Acopy, p, r)
        if pivot_idx + 1 < r:
            stack.append((pivot_idx + 1, r))
        if pivot_idx - 1 > p:
            stack.append((p, pivot_idx - 1))
    return Acopy


# Timing the arrays: use the timeit module

import timeit

def measure_time(array_len):
    A = np.random.randint(0, 2 * array_len, size=(array_len,))
    # setting `number` higher will give you more confidence in your timings
    time_sorted = timeit.timeit(stmt = lambda: sorted(A), number=5)
    time_qsort  = timeit.timeit(stmt = lambda: quicksort_iter(A), number=5)
