#!/usr/bin/env bash

# another way to write the statement below:
# [ ! -z "$1" ] && FILEPATH=${1} || FILEPATH = data.txt
FILEPATH=${1:-data.txt}

OUTPUT="$(basename ${FILEPATH})_summary.txt"
# can also do: OUTPUT="summary_of_${FILEPATH}"


echo ${FILEPATH##*/} >> ${OUTPUT}
echo "Analyzed on: $(date)" >> ${OUTPUT}
echo "Number of lines: $(wc -l < ${FILEPATH})" >> ${OUTPUT}
echo "Quick peek:" >> ${OUTPUT}
# To indent the output we have several options: one is to used `sed`
# and replace the beginning of each line with a tab, as below:
echo "$(head -n 5 ${FILEPATH})" | sed s/^/\\t/g >> ${OUTPUT}
# to output a tab with echo, need the -e flag (`man echo`)
echo -e "\t..." >> ${OUTPUT}
echo "$(tail -n 5 ${FILEPATH})" | sed s/^/\\t/g >> ${OUTPUT}
# another option to indent would be to iterate over all lines
# in $(head -n 5 ...) and explicitly output a tab character.
echo "File Type: $(file -b ${FILEPATH})" >> ${OUTPUT}
