#!/usr/bin/env bash

FOLDER=${1}

# get list of executable files in that folder
# -type f: makes sure we don't also list directories
# -perm /o=x: makes sure that the 'other' executable flag is set
XFILES=$(find ${FOLDER} -type f -perm /o=x -print0)

# Step 1: remove executable and read permissions from files
echo -n $XFILES | xargs -0 chmod uo-rx

# Step 2: strip leading path from files and put them in a file
echo -n $XFILES | xargs -0 -n1 basename > whoops.txt
