#!/usr/bin/env bash

FOLDER=${1}

# ASSUMPTION: filenames do not contain spaces

# get list of executable files in that folder
# -type f: makes sure we don't also list directories
# -perm /o=x: makes sure that the 'other' executable flag is set
XFILES=$(find ${FOLDER} -type f -perm /o=x)

# Loop over all filenames, remove read and executable permissions,
# and append the basename to the whoops.txt file
for f in $XFILES; do
	chmod go-rx ${f}
	echo ${f##*/} >> whoops.txt
done
